/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.MysqlDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.MysqlFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0016\u0018\u0000 )2\u00020\u0001:\u0001)B\u0007\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\r\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0013\u001a\u00020\u00122\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001b\u0010\u0017\u001a\u00020\u000b2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u0006R\u001b\u0010\u001f\u001a\u00020\u000b8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001aR\u001a\u0010 \u001a\u00020\u000b8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010\u001aR\u001a\u0010#\u001a\u00020\u000b8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b#\u0010!\u001a\u0004\b$\u0010\u001aR\u001a\u0010%\u001a\u00020\u000b8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b%\u0010!\u001a\u0004\b&\u0010\u001a\u00a8\u0006*"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "Lorg/jetbrains/exposed/sql/Schema;", "schema", "", "createSchema", "(Lorg/jetbrains/exposed/sql/Schema;)Ljava/lang/String;", "tableName", "indexName", "dropIndex", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "", "cascade", "dropSchema", "(Lorg/jetbrains/exposed/sql/Schema;Z)Ljava/lang/String;", "", "Lorg/jetbrains/exposed/sql/Table;", "tables", "", "fillConstraintCacheForTables", "(Ljava/util/List;)V", "Lorg/jetbrains/exposed/sql/Expression;", "e", "isAllowedAsColumnDefault", "(Lorg/jetbrains/exposed/sql/Expression;)Z", "isFractionDateTimeSupported", "()Z", "setSchema", "isMysql8$delegate", "Lkotlin/Lazy;", "isMysql8$exposed_core", "isMysql8", "supportsCreateSequence", "Z", "getSupportsCreateSequence", "supportsOrderByNullsFirstLast", "getSupportsOrderByNullsFirstLast", "supportsSubqueryUnions", "getSupportsSubqueryUnions", "<init>", "()V", "Companion", "exposed-core"})
public class MysqlDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy isMysql8$delegate = LazyKt.lazy((Function0)isMysql8.2.INSTANCE);
    private final boolean supportsCreateSequence;
    private final boolean supportsSubqueryUnions;
    private final boolean supportsOrderByNullsFirstLast;
    @NotNull
    public static final String dialectName = "mysql";

    public MysqlDialect() {
        super(dialectName, MysqlDataTypeProvider.INSTANCE, MysqlFunctionProvider.INSTANCE.INSTANCE);
        this.supportsSubqueryUnions = true;
    }

    public final boolean isMysql8$exposed_core() {
        Lazy lazy2 = this.isMysql8$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    public boolean getSupportsCreateSequence() {
        return this.supportsCreateSequence;
    }

    @Override
    public boolean getSupportsSubqueryUnions() {
        return this.supportsSubqueryUnions;
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return this.supportsOrderByNullsFirstLast;
    }

    public final boolean isFractionDateTimeSupported() {
        return TransactionManager.Companion.current().getDb().isVersionCovers(new BigDecimal("5.6"));
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        if (super.isAllowedAsColumnDefault(e)) {
            return true;
        }
        Object[] objectArray = new String[]{"CURRENT_TIMESTAMP", "CURRENT_TIMESTAMP()", "NOW()", "CURRENT_TIMESTAMP(6)", "NOW(6)"};
        Object[] acceptableDefaults = objectArray;
        return ArraysKt.contains((Object[])acceptableDefaults, (Object)((Object)StringsKt.trim((CharSequence)e.toString())).toString()) && this.isFractionDateTimeSupported();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void fillConstraintCacheForTables(@NotNull List<? extends Table> tables) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        Iterable $this$associateBy$iv = SchemaUtils.INSTANCE.sortTablesByReferences((Iterable<? extends Table>)tables);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Table table = (Table)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.nameInDatabaseCase(), element$iv$iv);
        }
        Map allTables = destination$iv$iv;
        Set<String> allTableNames = allTables.keySet();
        String inTableList = CollectionsKt.joinToString$default((Iterable)allTableNames, (CharSequence)"','", (CharSequence)" ku.TABLE_NAME IN ('", (CharSequence)"')", (int)0, null, null, (int)56, null);
        Transaction tr = TransactionManager.Companion.current();
        String schemaName = '\'' + this.getDatabase() + '\'';
        HashMap<String, Map<String, ForeignKeyConstraint>> constraintsToLoad = new HashMap<String, Map<String, ForeignKeyConstraint>>();
        Transaction.exec$default(tr, StringsKt.trimIndent((String)("SELECT\n                  rc.CONSTRAINT_NAME,\n                  ku.TABLE_NAME,\n                  ku.COLUMN_NAME,\n                  ku.REFERENCED_TABLE_NAME,\n                  ku.REFERENCED_COLUMN_NAME,\n                  rc.UPDATE_RULE,\n                  rc.DELETE_RULE\n                FROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS rc\n                  INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE ku\n                    ON ku.TABLE_SCHEMA = rc.CONSTRAINT_SCHEMA AND rc.CONSTRAINT_NAME = ku.CONSTRAINT_NAME\n                WHERE ku.TABLE_SCHEMA = " + schemaName + "\n                  AND ku.CONSTRAINT_SCHEMA = " + schemaName + "\n                  AND rc.CONSTRAINT_SCHEMA = " + schemaName + "\n                  AND " + inTableList + "\n                ORDER BY ku.ORDINAL_POSITION")), null, null, (Function1)new Function1<ResultSet, Unit>(allTableNames, this, tr, (Map<String, ? extends Table>)allTables, constraintsToLoad){
            final /* synthetic */ Set<String> $allTableNames;
            final /* synthetic */ MysqlDialect this$0;
            final /* synthetic */ Transaction $tr;
            final /* synthetic */ Map<String, Table> $allTables;
            final /* synthetic */ HashMap<String, Map<String, ForeignKeyConstraint>> $constraintsToLoad;
            {
                this.$allTableNames = $allTableNames;
                this.this$0 = $receiver;
                this.$tr = $tr;
                this.$allTables = $allTables;
                this.$constraintsToLoad = $constraintsToLoad;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ResultSet rs) {
                void $this$mapValuesTo$iv$iv;
                void $this$mapValues$iv;
                Object constraintUpdateRule;
                Column column;
                Map fromTableName;
                Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
                while (rs.next()) {
                    String constraintName;
                    Object object;
                    T element$iv3;
                    Column fromColumn;
                    Object object2;
                    block7: {
                        String targetTableName;
                        Object v1;
                        Column $this$firstOrNull$iv;
                        Transaction transaction2;
                        MysqlDialect mysqlDialect;
                        block6: {
                            Intrinsics.checkNotNull((Object)rs.getString("TABLE_NAME"));
                            if (!this.$allTableNames.contains(fromTableName)) continue;
                            String string = rs.getString("COLUMN_NAME");
                            Intrinsics.checkNotNull((Object)string);
                            String fromColumnName = this.this$0.quoteIdentifierWhenWrongCaseOrNecessary(string, this.$tr);
                            Iterable iterable = ((Table)MapsKt.getValue(this.$allTables, (Object)fromTableName)).getColumns();
                            mysqlDialect = this.this$0;
                            transaction2 = this.$tr;
                            boolean $i$f$firstOrNull = false;
                            object2 = $this$firstOrNull$iv.iterator();
                            while (object2.hasNext()) {
                                T element$iv2 = object2.next();
                                Column it = (Column)element$iv2;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)mysqlDialect.quoteIdentifierWhenWrongCaseOrNecessary(it.nameInDatabaseCase(), transaction2), (Object)fromColumnName)) continue;
                                v1 = element$iv2;
                                break block6;
                            }
                            v1 = null;
                        }
                        column = v1;
                        if (column == null) continue;
                        $this$firstOrNull$iv = column;
                        mysqlDialect = this.this$0;
                        transaction2 = this.$tr;
                        Map<String, Table> $i$f$firstOrNull = this.$allTables;
                        object2 = this.$constraintsToLoad;
                        fromColumn = $this$firstOrNull$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)rs.getString("CONSTRAINT_NAME"));
                        Intrinsics.checkNotNull((Object)rs.getString("REFERENCED_TABLE_NAME"));
                        String string = rs.getString("REFERENCED_COLUMN_NAME");
                        Intrinsics.checkNotNull((Object)string);
                        String targetColumnName = mysqlDialect.quoteIdentifierWhenWrongCaseOrNecessary(string, transaction2);
                        Iterable $this$first$iv = ((Table)MapsKt.getValue($i$f$firstOrNull, (Object)targetTableName)).getColumns();
                        boolean $i$f$first = false;
                        for (T element$iv3 : $this$first$iv) {
                            Column it = (Column)element$iv3;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)mysqlDialect.quoteIdentifierWhenWrongCaseOrNecessary(it.nameInDatabaseCase(), transaction2), (Object)targetColumnName)) continue;
                            break block7;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    Column targetColumn = (Column)element$iv3;
                    String string = rs.getString("UPDATE_RULE");
                    Intrinsics.checkNotNull((Object)string);
                    constraintUpdateRule = ReferenceOption.valueOf(StringsKt.replace$default((String)string, (String)" ", (String)"_", (boolean)false, (int)4, null));
                    String string2 = rs.getString("DELETE_RULE");
                    Intrinsics.checkNotNull((Object)string2);
                    ReferenceOption constraintDeleteRule = ReferenceOption.valueOf(StringsKt.replace$default((String)string2, (String)" ", (String)"_", (boolean)false, (int)4, null));
                    Map $this$getOrPut$iv = (Map)object2;
                    boolean $i$f$getOrPut = false;
                    V value$iv = $this$getOrPut$iv.get(fromTableName);
                    if (value$iv == null) {
                        boolean bl = false;
                        Map answer$iv = new LinkedHashMap<K, V>();
                        $this$getOrPut$iv.put(fromTableName, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((Map)object).merge(constraintName, new ForeignKeyConstraint(targetColumn, fromColumn, (ReferenceOption)((Object)constraintUpdateRule), constraintDeleteRule, constraintName), ForeignKeyConstraint::plus);
                }
                fromTableName = this.$constraintsToLoad;
                Map<String, Collection<ForeignKeyConstraint>> map2 = this.this$0.getColumnConstraintsCache();
                boolean $i$f$mapValues = false;
                column = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void $dstr$_u24__u24$v;
                    void it$iv$iv;
                    Map.Entry bl = (Map.Entry)element$iv$iv$iv;
                    Map map3 = destination$iv$iv;
                    boolean bl3 = false;
                    constraintUpdateRule = (Map.Entry)element$iv$iv$iv;
                    K k = it$iv$iv.getKey();
                    Map map4 = map3;
                    boolean bl4 = false;
                    Map v = (Map)$dstr$_u24__u24$v.getValue();
                    Collection<V> collection = v.values();
                    map4.put(k, collection);
                }
                map2.putAll(destination$iv$iv);
            }
        }, 6, null);
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName2) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)indexName2, (String)"indexName");
        return "ALTER TABLE " + tableName + " DROP INDEX " + indexName2;
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return Intrinsics.stringPlus((String)"USE ", (Object)schema.getIdentifier());
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        StringBuilder $this$createSchema_u24lambda_u2d1 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"CREATE SCHEMA IF NOT EXISTS ", schema.getIdentifier()};
        StringsKt.append((StringBuilder)$this$createSchema_u24lambda_u2d1, (String[])stringArray);
        if (schema.getAuthorization() != null) {
            throw new UnsupportedByDialectException(Intrinsics.stringPlus((String)DefaultKt.getCurrentDialect().getName(), (Object)" do not have database owners. You can use GRANT to allow or deny rights on database."), DefaultKt.getCurrentDialect());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return Intrinsics.stringPlus((String)"DROP SCHEMA IF EXISTS ", (Object)schema.getIdentifier());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlDialect$Companion;", "", "", "dialectName", "Ljava/lang/String;", "<init>", "()V", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

